require 'rubygems'
require 'rspec'

version = ">= 0"

if ARGV.first =~ /^_(.*)_$/ and Gem::Version.correct? $1 then
version = $1
ARGV.shift
end

gem 'rspec-core', version
load Gem.bin_path('rspec-core', 'rspec', version)

def element_present?(how, what)
   @driver.find_element(how, what)
   true
 rescue Selenium::WebDriver::Error::NoSuchElementError
   false
 end
 
def element_visible?(how, what)
   @driver.find_element(how, what).isDisplayed()
   true
 rescue Selenium::WebDriver::Error::NoSuchElementError
   false
 end
 
 def alert_present?()
   @driver.switch_to.alert
   true
 rescue Selenium::WebDriver::Error::NoAlertPresentError
   false
 end
 
 def verify(&blk)
   yield
 rescue ExpectationNotMetError => ex
   @verification_errors << ex
 end
 
 def close_alert_and_get_its_text(how, what)
   alert = @driver.switch_to().alert()
   alert_text = alert.text
   if (@accept_next_alert) then
     alert.accept()
   else
     alert.dismiss()
   end
   alert_text
 ensure
   @accept_next_alert = true
 end
 

def getElements(how, what)
    elements = []
    elements = @driver.find_elements(how, what)
    return elements
end

def resetInProgressNotes
  #connect to mongo instance and delete related notes for the provider
end

def listIsSortedDescending
  sorted = true
  if(list.size > 0)
    previousItem = list[0].downcase()
    for i in (0...list.size)
      nextItem = list[i].downcase()
      if(not previousItem >= nextItem)
        sorted = false
      end
      previousItem = nextItem
    end
  end
  return sorted
end
